************************************************************
* THE SPRITE HANDLING ROUTINES FOR KILLING SPREE           *
************************************************************

* CONTENTS:-
*
* SPRITE_48 :- 48 WIDE CALCULATES OWN MASKS
* SPRITE_32 :- 32 WIDE CALCULATES OWN MASKS
* SPRITE_16 :- 16 WIDE CALCULATES OWN MASKS
* SPRITE_16_TOWER :- USES 1 LINE D7 TIMES, CALCULATES OWN MASKS
* SPRITE_16_LASER :- FOR THE LASER BEAMS 13 LINES GFX THEN REST SAME
* HORIZONTAL_LINE :- DRAWS A RANDOMISED LINE FOR THE LASER GATES
*

* DATA LIST
*
* D5 = X POSITION
* D6 = Y POSITION
* D7 = NUMBER OF SPRITE LINES 
* A5 = SPRITE ROUT TO USE
* A0 = SPRITE DATA

**************************************************
* SHORT HANDLING ROUTINE TO GET STUFF WORKED OUT *
**************************************************
	
SPRITE_HANDLER:
	MOVE.W	D5,D2
	AND.W	#$F,D5			GET FRAME
	SUB.W	D5,D2
	LSR.W	#1,D2			GET X WORD OFFSET
	LSL.W	#5,D6			GET Y LINE OFFSET
	ADD.W	D6,A6
	ADD.W	D6,D6
	ADD.W	D6,D6
	ADD.W	D6,A6
	ADD.W	D2,A6
	MOVE.W	D5,D4
	ADD.W	D4,D4
	ADD.W	D4,D4
	MOVE.L	SPRITE_MASKS(PC,D4.W),D4
	JMP	(A5)			RUN IT!

SPRITE_MASKS:
	DC.L	%11111111111111111111111111111111
	DC.L	%01111111111111110111111111111111
	DC.L	%00111111111111110011111111111111
	DC.L	%00011111111111110001111111111111
	DC.L	%00001111111111110000111111111111
	DC.L	%00000111111111110000011111111111
	DC.L	%00000011111111110000001111111111
	DC.L	%00000001111111110000000111111111
	DC.L	%00000000111111110000000011111111
	DC.L	%00000000011111110000000001111111
	DC.L	%00000000001111110000000000111111
	DC.L	%00000000000111110000000000011111
	DC.L	%00000000000011110000000000001111
	DC.L	%00000000000001110000000000000111
	DC.L	%00000000000000110000000000000011
	DC.L	%00000000000000010000000000000001

********************************************************
* SPRITE ROUTS FOR 48 WIDE USING CALCULATED MASKS      *
* THESE ARE OPTIMISED FOR SPRITES WITH BLANK SPACE IN  *
* THEM A DIFFERENT ROUT MUST BE USED FOR LARGE GFX AREA*   
********************************************************

SPRITE_48:
	CMP.W	#8,D5
	BLT.S	SPRITE_48A
	SUBQ.W	#1,D5
	EOR.L	#15,D5
	BRA	SPRITE_48B

SPRITE_48A:
	MOVEQ	#0,D2
	MOVEQ	#0,D3
	MOVEQ	#0,D6
	MOVE.L	(A0)+,D0
	BEQ.S	.H1
	ROR.L	D5,D0
	MOVE.L	D0,D2
	AND.L	D4,D0
	EOR.L	D0,D2
	SWAP	D2
	MOVE.W	D0,D6
	SWAP	D0
	OR.W	D0,D6
.H1	MOVE.L	(A0)+,D1	
	BEQ.S	.H2
	ROR.L	D5,D1
	MOVE.L	D1,D3
	AND.L	D4,D1
	EOR.L	D1,D3
	SWAP	D3
	OR.W	D1,D6
	SWAP	D1
.H2	OR.W	D1,D6
	BEQ.S	.N48A1
	SWAP	D0			*--*
	SWAP	D1
	NOT.W	D6
	AND.W	D6,(A6)+
	AND.W	D6,(A6)+
	AND.W	D6,(A6)+
	AND.W	D6,(A6)+
	OR.L	D1,-(A6)
	OR.L	D0,-(A6)
.N48A1:	ADDQ.W	#8,A6
	MOVEQ	#0,D6
	MOVE.L	(A0)+,D0
	BEQ.S	.H3
	ROR.L	D5,D0
	MOVE.L	D0,D6
	AND.L	D4,D6
	EOR.L	D6,D0
	SWAP	D0
.H3	OR.L	D2,D6
	MOVEQ	#0,D2
	MOVE.L	(A0)+,D1
	BEQ.S	.H4
	ROR.L	D5,D1
	MOVE.L	D1,D2
	AND.L	D4,D2
	EOR.L	D2,D1
	SWAP	D1
.H4	OR.L	D3,D2

	MOVE.W	D6,D3
	SWAP	D6
	OR.W	D6,D3
	OR.W	D2,D3
	SWAP	D2
	OR.W	D2,D3
	BEQ.S	.N48A2
	SWAP	D2
	SWAP	D6			*--*
	NOT.W	D3
	AND.W	D3,(A6)+
	AND.W	D3,(A6)+
	AND.W	D3,(A6)+
	AND.W	D3,(A6)+
	OR.L	D2,-(A6)
	OR.L	D6,-(A6)
.N48A2:	ADDQ.W	#8,A6

	MOVEQ	#0,D6
	MOVE.L	(A0)+,D2
	BEQ.S	.H5
	ROR.L	D5,D2
	MOVE.L	D2,D6
	AND.L	D4,D2
	EOR.L	D2,D6
.H5	OR.L	D0,D2
	MOVEQ	#0,D0
	MOVE.L	(A0)+,D3
	BEQ.S	.H6
	ROR.L	D5,D3
	MOVE.L	D3,D0
	AND.L	D4,D3
	EOR.L	D3,D0
.H6	OR.L	D1,D3
	MOVE.W	D2,D1
	SWAP	D2
	OR.W	D2,D1
	OR.W	D3,D1
	SWAP	D3
	OR.W	D3,D1
	BEQ.S	.N48A3
	SWAP	D2			*--*
	SWAP	D3
	NOT.W	D1
	AND.W	D1,(A6)+
	AND.W	D1,(A6)+
	AND.W	D1,(A6)+
	AND.W	D1,(A6)+
	OR.L	D3,-(A6)
	OR.L	D2,-(A6)
.N48A3	ADDQ.W	#8,A6
	MOVE.L	D0,D1
	OR.L	D6,D1
	BEQ.S	.NO_DRAW_48A
	MOVE.W	D1,D2
	SWAP	D1
	OR.W	D2,D1
	NOT.W	D1
	MOVE.W	D1,D2
	SWAP	D1
	MOVE.W	D2,D1
	SWAP	D6
	SWAP	D0
	AND.L	D1,(A6)
	OR.L	D6,(A6)+
	AND.L	D1,(A6)
	OR.L	D0,(A6)+
	LEA	128(A6),A6
	DBF	D7,SPRITE_48A
	RTS
.NO_DRAW_48A
	LEA	128+8(A6),A6
	DBF	D7,SPRITE_48A
	RTS

SPRITE_48B:
	MOVEQ	#0,D2
	MOVEQ	#0,D3
	MOVEQ	#0,D6
	MOVE.L	(A0)+,D0
	BEQ.S	.H1
	ROL.L	D5,D0
	MOVE.L	D0,D2
	AND.L	D4,D0
	EOR.L	D0,D2
	MOVE.W	D0,D6
	SWAP	D0
	OR.W	D0,D6
	SWAP	D2
.H1	MOVE.L	(A0)+,D1	
	BEQ.S	.H2
	ROL.L	D5,D1
	MOVE.L	D1,D3
	AND.L	D4,D1
	EOR.L	D1,D3
	OR.W	D1,D6
	SWAP	D1
	SWAP	D3
.H2	OR.W	D1,D6
	BEQ.S	.N48B1
	NOT.W	D6
	AND.W	D6,(A6)+
	AND.W	D6,(A6)+
	AND.W	D6,(A6)+
	AND.W	D6,(A6)+
	OR.L	D1,-(A6)
	OR.L	D0,-(A6)
.N48B1:	ADDQ.W	#8,A6
	MOVEQ	#0,D6
	MOVE.L	(A0)+,D0
	BEQ.S	.H3
	ROL.L	D5,D0
	MOVE.L	D0,D6
	AND.L	D4,D6
	EOR.L	D6,D0
.H3	OR.L	D2,D6
	MOVEQ	#0,D2
	MOVE.L	(A0)+,D1
	BEQ.S	.H4
	ROL.L	D5,D1
	MOVE.L	D1,D2
	AND.L	D4,D2
	EOR.L	D2,D1
.H4	OR.L	D3,D2

	MOVE.W	D6,D3
	SWAP	D6
	OR.W	D6,D3
	OR.W	D2,D3
	SWAP	D2
	OR.W	D2,D3
	BEQ.S	.N48B2
	NOT.W	D3
	AND.W	D3,(A6)+
	AND.W	D3,(A6)+
	AND.W	D3,(A6)+
	AND.W	D3,(A6)+
	OR.L	D2,-(A6)
	OR.L	D6,-(A6)
.N48B2	ADDQ.W	#8,A6
	MOVEQ	#0,D6
	MOVE.L	(A0)+,D2
	BEQ.S	.H5
	ROL.L	D5,D2
	SWAP	D2
	MOVE.L	D2,D6
	AND.L	D4,D2
	EOR.L	D2,D6
.H5	OR.L	D0,D2
	MOVEQ	#0,D0
	MOVE.L	(A0)+,D3
	BEQ.S	.H6
	ROL.L	D5,D3
	SWAP	D3
	MOVE.L	D3,D0
	AND.L	D4,D3
	EOR.L	D3,D0
.H6	OR.L	D1,D3

	MOVE.W	D2,D1
	SWAP	D2
	OR.W	D2,D1
	OR.W	D3,D1
	SWAP	D3
	OR.W	D3,D1
	BEQ.S	.N48B3
	SWAP	D2
	SWAP	D3
	NOT.W	D1
	AND.W	D1,(A6)+
	AND.W	D1,(A6)+
	AND.W	D1,(A6)+
	AND.W	D1,(A6)+
	OR.L	D3,-(A6)
	OR.L	D2,-(A6)
.N48B3:	ADDQ.W	#8,A6
	MOVE.L	D0,D1
	OR.L	D6,D1
	BEQ.S	.NO_DRAW_48B
	MOVE.W	D1,D2
	SWAP	D1
	OR.W	D2,D1
	NOT.W	D1
	MOVE.W	D1,D2
	SWAP	D1
	MOVE.W	D2,D1
	SWAP	D6
	SWAP	D0
	AND.L	D1,(A6)
	OR.L	D6,(A6)+
	AND.L	D1,(A6)
	OR.L	D0,(A6)+
	LEA	128(A6),A6
	DBF	D7,SPRITE_48B
	RTS
.NO_DRAW_48B
	LEA	128+8(A6),A6
	DBF	D7,SPRITE_48B
	RTS

********************************************************
* SPRITE ROUTS FOR 32 WIDE USING CALCULATED MASKS      *
********************************************************

SPRITE_32:
	CMP.W	#8,D5
	BLT.S	SPRITE_32A
	SUBQ.W	#1,D5
	EOR.L	#15,D5
	BRA	SPRITE_32B

SPRITE_32A:
	MOVE.L	(A0)+,D0
	MOVE.L	(A0)+,D1
	ROR.L	D5,D0
	ROR.L	D5,D1
	MOVE.L	D0,D2
	MOVE.L	D1,D3
	AND.L	D4,D0
	AND.L	D4,D1
	EOR.L	D0,D2
	EOR.L	D1,D3
	MOVE.W	D0,D6
	SWAP	D0
	OR.W	D0,D6
	SWAP	D0
	OR.W	D1,D6
	SWAP	D1
	OR.W	D1,D6
	SWAP	D1
	NOT.W	D6
	AND.W	D6,(A6)
	AND.W	D6,2(A6)
	OR.L	D0,(A6)+
	AND.W	D6,(A6)
	AND.W	D6,2(A6)
	OR.L	D1,(A6)+
	SWAP	D2
	SWAP	D3
	MOVE.L	(A0)+,D0
	MOVE.L	(A0)+,D1
	ROR.L	D5,D0
	ROR.L	D5,D1
	MOVE.L	D0,D6
	AND.L	D4,D0
	EOR.L	D0,D6
	OR.L	D2,D0
	MOVE.L	D1,D2
	AND.L	D4,D1
	EOR.L	D1,D2
	OR.L	D3,D1
	MOVE.W	D0,D3
	SWAP	D0
	OR.W	D0,D3
	SWAP	D0
	OR.W	D1,D3
	SWAP	D1
	OR.W	D1,D3
	SWAP	D1
	NOT.W	D3
	AND.W	D3,(A6)
	AND.W 	D3,2(A6)
	OR.L	D0,(A6)+	
	AND.W	D3,(A6)
	AND.W 	D3,2(A6)
	OR.L	D1,(A6)+	
	MOVE.W	D6,D3
	SWAP	D6
	OR.W	D6,D3
	OR.W	D2,D3
	SWAP	D2
	OR.W	D2,D3
	NOT.W	D3
	AND.W	D3,(A6)
	AND.W 	D3,2(A6)
	OR.L	D6,(A6)+	
	AND.W	D3,(A6)
	AND.W 	D3,2(A6)
	OR.L	D2,(A6)+	
	LEA	136(A6),A6
	DBF	D7,SPRITE_32A		
	RTS

SPRITE_32B:
	MOVE.L	(A0)+,D0
	MOVE.L	(A0)+,D1	
	ROL.L	D5,D0
	ROL.L	D5,D1
	MOVE.L	D0,D2
	MOVE.L	D1,D3
	AND.L	D4,D0
	AND.L	D4,D1
	EOR.L	D0,D2
	EOR.L	D1,D3
	MOVE.W	D0,D6
	SWAP	D0
	OR.W	D0,D6
	OR.W	D1,D6
	SWAP	D1
	OR.W	D1,D6
	NOT.W	D6
	AND.W	D6,(A6)
	AND.W	D6,2(A6)
	OR.L	D0,(A6)+
	AND.W	D6,(A6)
	AND.W	D6,2(A6)
	OR.L	D1,(A6)+
	SWAP	D2
	SWAP	D3
	MOVE.L	(A0)+,D0
	MOVE.L	(A0)+,D1
	ROL.L	D5,D0
	ROL.L	D5,D1
	MOVE.L	D0,D6
	AND.L	D4,D6
	EOR.L	D6,D0
	OR.L	D2,D6
	MOVE.L	D1,D2
	AND.L	D4,D2
	EOR.L	D2,D1
	OR.L	D3,D2
	MOVE.W	D6,D3
	SWAP	D6
	OR.W	D6,D3
	OR.W	D2,D3
	SWAP	D2
	OR.W	D2,D3
	NOT.W	D3
	AND.W	D3,(A6)
	AND.W	D3,2(A6)
	OR.L	D6,(A6)+
	AND.W	D3,(A6)
	AND.W	D3,2(A6)
	OR.L	D2,(A6)+
	MOVE.W	D0,D6
	SWAP	D0
	OR.W	D0,D6
	SWAP	D0
	OR.W	D1,D6
	SWAP	D1
	OR.W	D1,D6
	SWAP	D1
	NOT.W	D6
	AND.W	D6,(A6)
	AND.W	D6,2(A6)
	OR.L	D0,(A6)+
	AND.W	D6,(A6)
	AND.W	D6,2(A6)
	OR.L	D1,(A6)+
	LEA	136(A6),A6
	DBF	D7,SPRITE_32B
	RTS

********************************************************
* SPRITE ROUTS FOR 16 WIDE USING CALCULATED MASKS      *
********************************************************

SPRITE_16:
	CMP.W	#8,D5
	BLT.S	SPRITE_16A
	SUBQ.W	#1,D5
	EOR.L	#15,D5
	BRA.S	SPRITE_16B

SPRITE_16A:
	MOVE.L	(A0)+,D0
	MOVE.L	(A0)+,D1
	ROR.L	D5,D0
	ROR.L	D5,D1
	MOVE.L	D0,D2
	MOVE.L	D1,D3
	AND.L	D4,D0
	AND.L	D4,D1
	EOR.L	D0,D2
	EOR.L	D1,D3
	MOVE.W	D0,D6
	SWAP	D0
	OR.W	D0,D6
	SWAP	D0
	OR.W	D1,D6
	SWAP	D1
	OR.W	D1,D6
	SWAP	D1
	NOT.W	D6
	AND.W	D6,(A6)
	AND.W	D6,2(A6)
	OR.L	D0,(A6)+
	AND.W	D6,(A6)
	AND.W	D6,2(A6)
	OR.L	D1,(A6)+
	MOVE.L	D2,D6
	OR.L	D3,D6
	BEQ.S	.NO_DRAW16A
	MOVE.W	D6,D0
	SWAP	D6
	OR.W	D0,D6
	NOT.W	D6
	MOVE.W	D6,D0
	SWAP	D6
	MOVE.W	D0,D6
	SWAP	D2
	SWAP	D3
	AND.L	D6,(A6)
	OR.L	D2,(A6)+	
	AND.L	D6,(A6)
	OR.L	D3,(A6)+	
	LEA	144(A6),A6
	DBF	D7,SPRITE_16A		
	RTS
.NO_DRAW16A:
	LEA	144+8(A6),A6
	DBF	D7,SPRITE_16A		
	RTS

SPRITE_16B:
	MOVE.L	(A0)+,D0
	MOVE.L	(A0)+,D1	
	ROL.L	D5,D0
	ROL.L	D5,D1
	MOVE.L	D0,D2
	MOVE.L	D1,D3
	AND.L	D4,D0
	AND.L	D4,D1
	EOR.L	D0,D2
	EOR.L	D1,D3
	MOVE.W	D0,D6
	SWAP	D0
	OR.W	D0,D6
	OR.W	D1,D6
	SWAP	D1
	OR.W	D1,D6
	NOT.W	D6
	AND.W	D6,(A6)
	AND.W	D6,2(A6)
	OR.L	D0,(A6)+
	AND.W	D6,(A6)
	AND.W	D6,2(A6)
	OR.L	D1,(A6)+
	MOVE.L	D2,D6
	OR.L	D3,D6
	BEQ.S	.NO_DRAW_16B
	MOVE.W	D6,D0
	SWAP	D6
	OR.W	D0,D6
	NOT.W	D6
	MOVE.W	D6,D0
	SWAP	D6
	MOVE.W	D0,D6
	AND.L	D6,(A6)
	OR.L	D2,(A6)+	
	AND.L	D6,(A6)
	OR.L	D3,(A6)+	
	LEA	144(A6),A6
	DBF	D7,SPRITE_16B
	RTS
.NO_DRAW_16B:
	LEA	144+8(A6),A6
	DBF	D7,SPRITE_16B
	RTS

********************************************************
* SPRITE ROUTS FOR 16 WIDE USING CALCULATED MASKS      *
* ESPECIALLY FOR THE LASER GATE TOWERS                 *
********************************************************

SPRITE_16_TOWER:
	MOVE.W	(A3),D7			GET CORRECT HEIGHT OFFSET
	LSL.W	#5,D7
	SUB.W	D7,A6
	ADD.W	D7,D7
	ADD.W	D7,D7
	SUB.W	D7,A6
	MOVE.W	D5,-(A7)
	MOVEQ	#11-1,D7
	BSR	SPRITE_16		EXTRA 5 LINES
	MOVE.W	(A7),D5
	MOVE.L	(A0)+,D0
	MOVE.L	(A0)+,D1
	ROR.L	D5,D0
	ROR.L	D5,D1
	MOVE.L	D0,D2
	MOVE.L	D1,D3
	AND.L	D4,D0
	AND.L	D4,D1
	EOR.L	D0,D2
	EOR.L	D1,D3
	MOVE.L	D0,D5
	OR.L	D1,D5
	MOVE.W	D5,D7
	SWAP	D5
	OR.W	D7,D5
	NOT.W	D5
	MOVE.W	D5,D7
	SWAP	D5
	MOVE.W	D7,D5
	MOVE.L	D2,D6
	OR.L	D3,D6
	MOVE.W	D6,D7
	SWAP	D6
	OR.W	D7,D6
	NOT.W	D6
	MOVE.W	D6,D7
	SWAP	D6
	MOVE.W	D7,D6
	SWAP	D2
	SWAP	D3
	MOVE.W	(A3)+,D7	
.SPRITE_LOOP:
	AND.L	D5,(A6)
	OR.L	D0,(A6)+
	AND.L	D5,(A6)	
	OR.L	D1,(A6)+
	AND.L	D6,(A6)
	OR.L	D2,(A6)+	
	AND.L	D6,(A6)
	OR.L	D3,(A6)+	
	LEA	144(A6),A6
	DBF	D7,.SPRITE_LOOP
	MOVE.W	(A7)+,D5
	MOVEQ	#1,D7			EXTRA 2 LINES
	BSR	SPRITE_16
	RTS

********************************************************
* SPRITE ROUTS FOR 16 WIDE USING CALCULATED MASKS      *
* ESPECIALLY FOR THE VERTICAL LASERS FIRED BY BASES    *
********************************************************

SPRITE_16_LASER:
	MOVE.W	(A3),D7			GET CORRECT HEIGHT OFFSET
	LSL.W	#5,D7
	SUB.W	D7,A6
	ADD.W	D7,D7
	ADD.W	D7,D7
	SUB.W	D7,A6
	MOVE.W	D5,-(A7)
	MOVEQ	#13-1,D7
	BSR	SPRITE_16		EXTRA 5 LINES
	MOVE.W	(A7)+,D5
	MOVE.L	(A0)+,D0
	MOVE.L	(A0)+,D1
	ROR.L	D5,D0
	ROR.L	D5,D1
	MOVE.L	D0,D2
	MOVE.L	D1,D3
	AND.L	D4,D0
	AND.L	D4,D1
	EOR.L	D0,D2
	EOR.L	D1,D3
	MOVE.L	D0,D5
	OR.L	D1,D5
	MOVE.W	D5,D7
	SWAP	D5
	OR.W	D7,D5
	NOT.W	D5
	MOVE.W	D5,D7
	SWAP	D5
	MOVE.W	D7,D5
	MOVE.L	D2,D6
	OR.L	D3,D6
	MOVE.W	D6,D7
	SWAP	D6
	OR.W	D7,D6
	NOT.W	D6
	MOVE.W	D6,D7
	SWAP	D6
	MOVE.W	D7,D6
	SWAP	D2
	SWAP	D3
	MOVE.W	(A3)+,D7
.SPRITE_LOOP:
	AND.L	D5,(A6)
	OR.L	D0,(A6)+
	AND.L	D5,(A6)	
	OR.L	D1,(A6)+
	AND.L	D6,(A6)
	OR.L	D2,(A6)+	
	AND.L	D6,(A6)
	OR.L	D3,(A6)+	
	LEA	144(A6),A6
	DBF	D7,.SPRITE_LOOP
	RTS

**************************************************
* SPECIAL HORIZONTAL LINE ROUTINES FOR THE LASER *
* GATES                                          *
**************************************************

LINE_MASK:	DC.L	$98765432

HORIZONTAL_LINE:
	MOVEM.W	LINE_MASK(PC),D6-D7	GET RANDOM LINE MASK
	ROR.W	#1,D6
	ADDQ.W	#7,D6
	EOR.W	D7,D6
	EXG	D6,D7
	MOVEM.W	D6-D7,LINE_MASK
	MOVE.W	D7,D6
	SWAP	D7
	MOVE.W	D6,D7			LONG WORD LINE MASK
	AND.W	#3,D6
	ADD.W	D6,D6
	ADD.W	D6,D6
	MOVE.L	.ROUT_TAB(PC,D6.W),A5
	MOVE.W	(A3)+,D2		GET RIGHT COORDINATE
	ADD.W	D5,D2			RESTABLISH RIGHT POS
	ADD.W	D5,D5
	LEA	LEFT_MASKS(PC),A0
	MOVE.W	(A0,D5.W),D5		LEFT MASK
	MOVE.W	D2,D0
	AND.W	#15,D0
	SUB.W	D0,D2			GET RIGHT X WORD BOUNDARY
	ADD.W	D0,D0
	MOVE.W	64(A0,D0.W),D0		RIGHT MASK
	JMP	(A5)

.ROUT_TAB:
	DC.L	.GREY1,.GREY2,.GREY3,.GREY4

.GREY1:
	SUB.W	#16,D2
	BMI.S	.ONE_WORD1
	AND.W	D7,D5
	MOVE.W	D5,D6
	NOT.W	D6
	AND.W	D7,D0
	MOVE.W	D0,D1
	NOT.W	D1
	AND.W	D6,(A6)+
	AND.W	D6,(A6)+
	OR.W	D5,(A6)+
	OR.W	D5,(A6)+
	
	MOVEQ	#-1,D6
	AND.L	D7,D6
	MOVE.L	D6,D5
	NOT.L	D5
	LSR.W	#2,D2
	NEG.W	D2
	JMP	.LINE_TOWER1(PC,D2.W)
	REPT	20
	AND.L	D5,(A6)+
	OR.L	D6,(A6)+
	ENDR
.LINE_TOWER1:	
	AND.W	D1,(A6)+
	AND.W	D1,(A6)+
	OR.W	D0,(A6)+
	OR.W	D0,(A6)+
	RTS
.ONE_WORD1:
	AND.W	D5,D0
	MOVE.W	D0,D1
	NOT.W	D1
	AND.W	D1,(A6)+
	AND.W	D1,(A6)+
	OR.W	D0,(A6)+
	OR.W	D0,(A6)+
	RTS

.ONE_WORD2:
	AND.W	D5,D0
	MOVE.W	D0,D1
	NOT.W	D1
	OR.W	D0,(A6)+
	AND.W	D1,(A6)+
	OR.W	D0,(A6)+
	OR.W	D0,(A6)+
	RTS

.GREY2:
	SUB.W	#16,D2
	BMI.S	.ONE_WORD2
	AND.W	D7,D5
	MOVE.W	D5,D6
	NOT.W	D6
	AND.W	D7,D0
	MOVE.W	D0,D1
	NOT.W	D1
	OR.W	D5,(A6)+
	AND.W	D6,(A6)+
	OR.W	D5,(A6)+
	OR.W	D5,(A6)+
	
	MOVEQ	#-1,D6
	AND.L	D7,D6
	MOVE.L	D6,D5
	NOT.L	D5
	LSR.W	#1,D2
	NEG.W	D2
	LEA	.LINE_TOWER2(PC),A5
	JMP	(A5,D2.W)
	REPT	20
	OR.W	D6,(A6)+
	AND.W	D5,(A6)+
	OR.W	D6,(A6)+
	OR.W	D6,(A6)+
	ENDR
.LINE_TOWER2:	
	OR.W	D0,(A6)+
	AND.W	D1,(A6)+
	OR.W	D0,(A6)+
	OR.W	D0,(A6)+
	RTS

.ONE_WORD3:
	AND.W	D5,D0
	MOVE.W	D0,D1
	NOT.W	D1
	AND.W	D1,(A6)+
	OR.W	D0,(A6)+
	OR.W	D0,(A6)+
	OR.W	D0,(A6)+
	RTS

.GREY3:
	SUB.W	#16,D2
	BMI.S	.ONE_WORD3
	AND.W	D7,D5
	MOVE.W	D5,D6
	NOT.W	D6
	AND.W	D7,D0
	MOVE.W	D0,D1
	NOT.W	D1
	AND.W	D6,(A6)+
	OR.W	D5,(A6)+
	OR.W	D5,(A6)+
	OR.W	D5,(A6)+
	
	MOVEQ	#-1,D6
	AND.L	D7,D6
	MOVE.L	D6,D5
	NOT.L	D5
	LSR.W	#1,D2
	NEG.W	D2
	LEA	.LINE_TOWER3(PC),A5
	JMP	(A5,D2.W)
	REPT	20
	AND.W	D5,(A6)+
	OR.W	D6,(A6)+
	OR.W	D6,(A6)+
	OR.W	D6,(A6)+
	ENDR
.LINE_TOWER3:	
	AND.W	D1,(A6)+
	OR.W	D0,(A6)+
	OR.W	D0,(A6)+
	OR.W	D0,(A6)+
	RTS

.GREY4:
	SUB.W	#16,D2
	BMI.S	.ONE_WORD4
	AND.W	D7,D5
	AND.W	D7,D0
	OR.W	D5,(A6)+
	OR.W	D5,(A6)+
	OR.W	D5,(A6)+
	OR.W	D5,(A6)+
	
	MOVEQ	#-1,D6
	AND.L	D7,D6
	LSR.W	#2,D2
	NEG.W	D2
	JMP	.LINE_TOWER4(PC,D2.W)
	REPT	20
	OR.L	D6,(A6)+
	OR.L	D6,(A6)+
	ENDR
.LINE_TOWER4:	
	OR.W	D0,(A6)+
	OR.W	D0,(A6)+
	OR.W	D0,(A6)+
	OR.W	D0,(A6)+
	RTS
.ONE_WORD4:
	AND.W	D5,D0
	MOVE.W	D0,D1
	NOT.W	D1
	OR.W	D0,(A6)+
	OR.W	D0,(A6)+
	OR.W	D0,(A6)+
	OR.W	D0,(A6)+
	RTS
